// $Id: CMidiViz.cpp,v 1.9 2007/02/27 19:48:10 paul Exp $

/*
 * All contents of this source code are copyright 2007 Exp Digital Uk.
 * This file forms part of the example projects for the Infinity API.
 * You may not redistribute either the source code or the compiled binary.
 * The Infinity API is covered by a fair use licence which you should have recieved with this
 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
 */

#include "CMidiViz.hpp"
#include "CMidiVizEditor.hpp"
using Exponent::MidiViz::CMidiViz;
using Exponent::MidiViz::CMidiVizEditor;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CMidiViz, CVstEffect);

//	===========================================================================
CMidiViz::CMidiViz(audioMasterCallback audioMaster) : CVstEffect(audioMaster, 0, 0)
{
	EXPONENT_CLASS_CONSTRUCTION(CMidiViz);

	// Stereo in
	this->setNumInputs(2);
	this->setNumOutputs(2);
	#ifndef VST_2_4_EXTENSIONS
	this->canMono();
	#endif
	this->canProcessReplacing();
	this->setUniqueID('ExMv');

	// Create the editors window attributes
	CWindowAttributes attributes;
	attributes.setBackgroundColour(CColour::CCOLOUR_WHITE);

	// Pass to the editor
	editor = new CMidiVizEditor(this, CRect(0, 0, 280, 480), &attributes);

	// What is the visibility
	m_visibility = e_allEvents;
}

//	===========================================================================
CMidiViz::~CMidiViz()
{
	EXPONENT_CLASS_DESTRUCTION(CMidiViz);

	this->closeStream();

		// Clear the image manager
	#ifndef WIN32
		 STOP_EXPONENT_API_NO_LOG;
	#endif
}

//	===========================================================================
#ifdef VST_2_4_EXTENSIONS
VstInt32 CMidiViz::canDo(char *text)
#else
long CMidiViz::canDo(char *text)
#endif
{
	#ifdef VST_2_4_EXTENSIONS
	VstInt32 code = CVst::CVST_I_CANT_DO;
	#else
	long code = CVst::CVST_I_CANT_DO;
	#endif
	if (text)
	{
		if (!strcmp (text, "receiveVstEvents"))			code = CVst::CVST_I_CAN_DO;
		else if (!strcmp (text, "receiveVstMidiEvent")) code = CVst::CVST_I_CAN_DO;
		else if (!strcmp (text, "plugAsChannelInsert")) code = CVst::CVST_I_CAN_DO;
		else if (!strcmp (text, "plugAsSend"))			code = CVst::CVST_I_CAN_DO;
		else if (!strcmp (text, "2in2out"))				code = CVst::CVST_I_CAN_DO;
	}
	return code;
}

//	===========================================================================
#ifdef VST_2_4_EXTENSIONS
bool CMidiViz::getOutputProperties(VstInt32 index, VstPinProperties* properties)
#else
bool CMidiViz::getOutputProperties(long index, VstPinProperties* properties)
#endif
{
	if (index == 0 || index == 1)
	{
		properties->flags = kVstPinIsActive | kVstPinIsStereo;
	}
	if (index == 0)
	{
		strcpy(properties->label,	   "Left output");
		strcpy(properties->shortLabel, "L out");
		return true;
	}
	else if (index == 1)
	{
		strcpy(properties->label,	   "Right output");
		strcpy(properties->shortLabel, "R out");
		return true;
	}
	return false;
}

//	===========================================================================
#ifdef VST_2_4_EXTENSIONS
bool CMidiViz::getInputProperties(VstInt32 index, VstPinProperties *properties)
#else
bool CMidiViz::getInputProperties(long index, VstPinProperties *properties)
#endif
{
	if (index == 0 || index == 1)
	{
		properties->flags = kVstPinIsActive | kVstPinIsStereo;
	}
	if (index == 0)
	{
		strcpy(properties->label,	   "Left input");
		strcpy(properties->shortLabel, "L in");
		return true;
	}
	else if (index == 1)
	{
		strcpy(properties->label,	   "Right input");
		strcpy(properties->shortLabel, "R in");
		return true;
	}
	return false;
}

//	===========================================================================
#ifdef VST_2_4_EXTENSIONS
void CMidiViz::process(float **input, float **output, VstInt32 numberOfSamples)
#else
void CMidiViz::process(float **input, float **output, long numberOfSamples)
#endif
{
	for (long i = 0; i < numberOfSamples; i++)
	{
		output[0][i] += input[0][i];
		output[1][i] += input[1][i];
	}
	CVstEffect::process(input, output, numberOfSamples);
}

//	===========================================================================
#ifdef VST_2_4_EXTENSIONS
void CMidiViz::processReplacing(float **input, float **output, VstInt32 numberOfSamples)
#else
void CMidiViz::processReplacing(float **input, float **output, long numberOfSamples)
#endif
{
	memcpy(output[0], input[0], numberOfSamples * sizeof(float));
	memcpy(output[1], input[1], numberOfSamples * sizeof(float));
	CVstEffect::processReplacing(input, output, numberOfSamples);
}

//	===========================================================================
#ifdef VST_2_4_EXTENSIONS
VstInt32 CMidiViz::processEvents (VstEvents *events)
#else
long CMidiViz::processEvents (VstEvents *events)
#endif
{
	// Add the vst events
	m_midiEventList.addFromVSTEvent(events);

	// Check we aint wasting our time!
	if (m_midiEventList.getNumberOfEvents() == 0)
	{
		// we want more events next time :)
		return CVst::CVST_WANT_MORE_EVENTS;
	}

	// Stream and editor available
	if (m_outputStream.isStreamOpen() && editor)
	{
		// A variable for stream otuput
		char output[1024];

		// Cast the editor
		CMidiVizEditor *midiVizEditor = (CMidiVizEditor *)editor;

		// Store the size
		const long size = m_midiEventList.getNumberOfEvents();

		// Now loop through the events
		for (long i = 0; i < size; i++)
		{
			// Get the midi event
			const CMidiEvent *event = m_midiEventList.getEventAtIndex(i);

			// Check its valid
			if (event == NULL)
			{
				continue;
			}

			// Remove non visible events
			switch(m_visibility)
			{
				case e_allEvents:

				break;
				case e_notesOnly:
					if (!(event->isNoteOff() || event->isNoteOn() || event->isAllNotesOff()))
					{
						continue;
					}
				break;
				case e_ccOnly:
					if (!event->isControlChange())
					{
						continue;
					}
				break;
				case e_notesAndCCOnly:
					if (!(event->isNoteOff() || event->isNoteOn() || event->isAllNotesOff() || event->isControlChange()))
					{
						continue;
					}
				break;
				case e_otherOnly:
					if (event->isNoteOff() || event->isNoteOn() || event->isAllNotesOff() || event->isControlChange())
					{
						continue;
					}
				break;
			}

			// Notify the graphics
			midiVizEditor->addEvent(*event);

			// Now stream it
			event->getObjectDescription(output, 1024);

			// Output it to the stream
			m_outputStream << output << "\n";
		}
	}
	else if (m_outputStream.isStreamOpen() && editor == NULL)
	{
		// A variable for stream otuput
		char output[1024];

		// Store the size
		const long size = m_midiEventList.getNumberOfEvents();

		// Now loop through the events
		for (long i = 0; i < size; i++)
		{
			// Get the midi event
			const CMidiEvent *event = m_midiEventList.getEventAtIndex(i);

			// Check its valid
			if (event == NULL)
			{
				continue;
			}

			// Now stream it
			event->getObjectDescription(output, 1024);

			// Output it to the stream
			m_outputStream << output << "\n";
		}
	}
	else if (!m_outputStream.isStreamOpen() && editor)
	{
		// Cast the editor
		CMidiVizEditor *midiVizEditor = (CMidiVizEditor *)editor;

		// Store the size
		const long size = m_midiEventList.getNumberOfEvents();

		// Now loop through the events
		for (long i = 0; i < size; i++)
		{
			// Get the midi event
			const CMidiEvent *event = m_midiEventList.getEventAtIndex(i);

			// Check its valid
			if (event == NULL)
			{
				continue;
			}

			// Remove non visible events
			switch(m_visibility)
			{
				case e_allEvents:

				break;
				case e_notesOnly:
					if (!(event->isNoteOff() || event->isNoteOn() || event->isAllNotesOff()))
					{
						continue;
					}
				break;
				case e_ccOnly:
					if (!event->isControlChange())
					{
						continue;
					}
				break;
				case e_notesAndCCOnly:
					if (!(event->isNoteOff() || event->isNoteOn() || event->isAllNotesOff() || event->isControlChange()))
					{
						continue;
					}
				break;
				case e_otherOnly:
					if (event->isNoteOff() || event->isNoteOn() || event->isAllNotesOff() || event->isControlChange())
					{
						continue;
					}
				break;
			}

			// Notify the graphics
			midiVizEditor->addEvent(*event);
		}
	}

	// we want more events next time :)
	return CVst::CVST_WANT_MORE_EVENTS;
}

//	===========================================================================
void CMidiViz::openStream(const CSystemString &filename)
{
	this->closeStream();
	m_outputStream.openStream(filename, CTextStream::e_output);
}

//	===========================================================================
void CMidiViz::closeStream()
{
	if (m_outputStream.isStreamOpen())
	{
		m_outputStream.closeStream();
	}
}